#define _CRT_SECURE_NO_WARNINGS
#include <bits/stdc++.h>

using namespace std;

class Jarbol
{
private:

    int x;
    int y;
    int i;

public:

    int getX() { return x; }
    void setX(int x) { this->x = x; }
    int getY() { return y; }
    void setY(int y) { this->y = y; }
    int getI() { return i; }
    void setI(int i) { this->i = i; }

    int PresekDesno(int y) { return this->x + this->y - y; }
    int PresekLevo(int y) { return this->x - this->y + y; }

    static int NajbliziVisiLevo(vector <Jarbol>& jarboli, int duzina, int indeks)
    {
        Jarbol pocetni = jarboli[indeks];
        int i = indeks-1;
        bool flagNadjen = false;

        for (; i > -1; i--)
        {
            if (jarboli[i].getY() > pocetni.getY())
            {
                flagNadjen = true;
                break;
            }
        }

        if (!flagNadjen) return -1;
        return pocetni.getX() - jarboli[i].PresekDesno(pocetni.getY());
    }

    static int NajbliziVisiDesno(vector <Jarbol>& jarboli, int duzina, int indeks)
    {
        Jarbol pocetni = jarboli[indeks];
        int i = indeks+1;
        bool flagNadjen = false;

        for (; i < duzina; i++)
        {
            if (jarboli[i].getY() > pocetni.getY())
            {
                flagNadjen = true;
                break;
            }
        }

        if (!flagNadjen) return -1;
        return jarboli[i].PresekLevo(pocetni.getY()) - pocetni.getX();

    }
};

int main()
{
    int n;
    int pom;
    

    scanf("%d", &n);

    vector <Jarbol> jarboli(n);

    for (int i = 0; i < n; i++)
    {
        scanf("%d", &pom);
        jarboli[i].setX(pom);
        jarboli[i].setI(i);
    }

    for (int i = 0; i < n; i++)
    {
        scanf("%d", &pom);
        jarboli[i].setY(pom);
    }

    sort(jarboli.begin(), jarboli.end(),
        [](Jarbol t1, Jarbol t2) { return t1.getX() < t2.getX(); 
        });

    vector <int> output(n);

    int najbliziVisiDesno = 0, najbliziVisiLevo = 0;

    for (int i = 0; i < n; i++)
    {
        najbliziVisiDesno = Jarbol::NajbliziVisiDesno(jarboli, n, i);
        najbliziVisiLevo = Jarbol::NajbliziVisiLevo(jarboli, n, i);

        if (najbliziVisiDesno == -1 && najbliziVisiLevo == -1)
            output[jarboli[i].getI()] = -1;
        else if (najbliziVisiDesno == -1)
            output[jarboli[i].getI()] = (najbliziVisiLevo);
        else if (najbliziVisiLevo == -1)
            output[jarboli[i].getI()] = (najbliziVisiDesno);
        else
            output[jarboli[i].getI()] = (najbliziVisiDesno < najbliziVisiLevo ? najbliziVisiDesno : najbliziVisiLevo);
    }

    for (int i = 0; i < n; i++) printf("%d\n", output[i]);

    return 0;
}